	!dp = $0000
	!addr = $0000
    !rom = $800000
	!sa1 = 0
	!gsu = 0
    !sram7000 = $000000
    !sram7008 = $000000
    !ram7F9A7B = $000000
    !ram7FC700 = $000000

if read1($00FFD6) == $15
	sfxrom
	!dp = $6000
	!addr = !dp
	!gsu = 1
elseif read1($00FFD5) == $23
	sa1rom
	!dp = $3000
	!addr = $6000
	!sa1 = 1
    !rom = $000000
    !sram7000 = $2E4000
    !sram7008 = $2E6800
    !ram7F9A7B = $3E127B
    !ram7FC700 = $3DFF00
endif

;########################################
;######## Scratchs Rams [$00,$0F] #######
;########################################
!Scratch0 = $00
!Scratch1 = $01
!Scratch2 = $02
!Scratch3 = $03
!Scratch4 = $04
!Scratch5 = $05
!Scratch6 = $06
!Scratch7 = $07
!Scratch8 = $08
!Scratch9 = $09
!ScratchA = $0A
!ScratchB = $0B
!ScratchC = $0C
!ScratchD = $0D
!ScratchE = $0E
!ScratchF = $0F

;########################################
;############## Counters ################
;########################################
!TrueFrameCounter = $13
!EffectiveFrameCounter = $14

;########################################
;############## Control #################
;########################################
!ButtonPressed_BYETUDLR = $15
!ButtonDown_BYETUDLR = $16
!ButtonPressed_AXLR0000 = $17
!ButtonDown_AXLR0000 = $18

;########################################
;############## Layers ##################
;########################################
!Layer1X = $1A
!Layer1Y = $1C
!Layer2X = $1E
!Layer2Y = $20
!Layer3X = $22
!Layer3Y = $24

;########################################
;############## Player ##################
;########################################
!PlayerX = $94
!PlayerY = $96
!PlayerXSpeed = $7B
!PlayerYSpeed = $7D
!PowerUp = $19
!Lives = $0DBE|!addr
!Coins = $0DBF|!addr
!ItemBox = $0DC2|!addr
!PlayerInAirFlag = $72
!PlayerDuckingFlag = $73
!PlayerClimbingFlag_N00SIFHB = $74
!PlayerWaterFlag = $75
!PlayerDirection = $76
!PlayerBlockedStatus_S00MUDLR = $77
!PlayerHide_DLUCAPLU = $78
!CurrentPlayer = $0DB3|!addr
!CapeImage = $13DF|!addr
!PlayerPose = $13E0|!addr
!PlayerSlope = $13E1|!addr
!SpinjumpTimer = $13E2|!addr
!PlayerWallRunningFlag = $13E3|!addr
!PlayerFrozenFlag = $13FB|!addr
!PlayerCarryingFlag = $1470|!addr
!PlayerCarryingFlagImage = $148F|!addr
!PlayerAnimationTimer = $1496|!addr
!PlayerFlashingTimer = $1497|!addr
!P1PowerUp = $0DB8|!addr
!P2PowerUp = $0DB9|!addr
!P1Lives = $0DB4|!addr
!P2Lives = $0DB5|!addr
!P1Coins = $0DB6|!addr
!P2Coins = $0DB7|!addr
!P1YoshiColor = $0DBA|!addr
!P2YoshiColor = $0DBB|!addr
!P1ItemBox = $0DBC|!addr
!P2ItemBox = $0DBD|!addr

;########################################
;############### Global #################
;########################################
!LockAnimationFlag = $9D
!HScrollEnable = $1411|!addr
!VScrollEnable = $1412|!addr
!HScrollLayer2Type = $1413|!addr
!VScrollLayer2Type = $1414|!addr
!WaterFlag = $85
!SlipperyFlag = $86
!GameMode = $0100|!addr
!TwoPlayersFlag = $0DB2|!addr

;########################################
;################ OAM ###################
;########################################
!TileXPosition200 = $0200|!addr
!TileYPosition200 = $0201|!addr
!TileCode200 = $0202|!addr
!TileProperty200 = $0203|!addr
!TileSize420 = $0420|!addr
!TileXPosition = $0300|!addr
!TileYPosition = $0301|!addr
!TileCode = $0302|!addr
!TileProperty = $0303|!addr
!TileSize460 = $0460|!addr

;########################################
;############### Yoshi ##################
;########################################
!YoshiX = $18B0|!addr
!YoshiY = $18B2|!addr
!YoshiKeyInMouthFlag = $191C|!addr

;########################################
;############## Clusters ################
;########################################
!ClusterNumber = $1892|!addr
!ClusterXLow = $1E16|!addr
!ClusterYLow = $1E02|!addr
!ClusterXHigh = $1E3E|!addr
!ClusterYHigh = $1E2A|!addr
!ClusterMiscTable1 = $0F4A|!addr
!ClusterMiscTable2 = $0F5E|!addr
!ClusterMiscTable3 = $0F72|!addr
!ClusterMiscTable4 = $0F86|!addr
!ClusterMiscTable5 = $0F9A|!addr
!ClusterMiscTable6 = $1E52|!addr
!ClusterMiscTable7 = $1E66|!addr
!ClusterMiscTable8 = $1E7A|!addr
!ClusterMiscTable9 = $1E8E|!addr

;########################################
;############## Extended ################
;########################################
!ExtendedNumber = $170B|!addr
!ExtendedXLow = $171F|!addr
!ExtendedYLow = $1715|!addr
!ExtendedXHigh = $1733|!addr
!ExtendedYHigh = $1729|!addr
!ExtendedXSpeed = $1747|!addr
!ExtendedYSpeed = $173D|!addr
!ExtendedXSpeedAccumulatingFraction = $175B|!addr
!ExtendedYSpeedAccumulatingFraction = $1751|!addr
!ExtendedBehindLayersFlag = $1779|!addr
!ExtendedMiscTable1 = $1765|!addr
!ExtendedMiscTable2 = $176F|!addr

;########################################
;############### Sprites ################
;########################################
!SpriteIndex = $15E9|!addr
!SpriteNumber = $9E
!SpriteStatus = $14C8
!SpriteXLow = $E4
!SpriteYLow = $D8
!SpriteXHigh = $14E0
!SpriteYHigh = $14D4
!SpriteXSpeed = $B6
!SpriteYSpeed = $AA
!SpriteXSpeedAccumulatingFraction = $14F8
!SpriteYSpeedAccumulatingFraction = $14EC
!SpriteDirection = $157C
!SpriteBlockedStatus_ASB0UDLR = $1588
!SpriteHOffScreenFlag = $15A0
!SpriteVOffScreenFlag = $186C
!SpriteHMoreThan4TilesOffScreenFlag = $15C4
!SpriteSlope = $15B8
!SpriteYoshiTongueFlag = $15D0
!SpriteInteractionWithObjectEnable = $15DC
!SpriteIndexOAM = $15EA
!SpriteProperties_YXPPCCCT = $15F6
!SpriteLoadStatus = $161A
!SpriteBehindEscenaryFlag = $1632
!SpriteInLiquidFlag = $164A
!SpriteDecTimer1 = $1540
!SpriteDecTimer2 = $154C
!SpriteDecTimer3 = $1558
!SpriteDecTimer4 = $1564
!SpriteDecTimer5 = $15AC
!SpriteDecTimer6 = $163E
!SpriteDecTimer7 = $1FE2
!SpriteTweaker1656_SSJJCCCC = $1656
!SpriteTweaker1662_DSCCCCCC = $1662
!SpriteTweaker166E_LWCFPPPG = $166E
!SpriteTweaker167A_DPMKSPIS = $167A
!SpriteTweaker1686_DNCTSWYE = $1686
!SpriteTweaker190F_WCDJ5SDP = $190F
!SpriteMiscTable1 = $0DF5|!addr
!SpriteMiscTable2 = $0E0B|!addr
!SpriteMiscTable3 = $C2
!SpriteMiscTable4 = $1504
!SpriteMiscTable5 = $1510
!SpriteMiscTable6 = $151C
!SpriteMiscTable7 = $1528
!SpriteMiscTable8 = $1534
!SpriteMiscTable9 = $1570
!SpriteMiscTable10 = $1594
!SpriteMiscTable11 = $1602
!SpriteMiscTable12 = $160E
!SpriteMiscTable13 = $1626
!SpriteMiscTable14 = $187B
!SpriteMiscTable15 = $1FD6

;########################################
;############### GIEPY ##################
;########################################
!ExtraBits = $7FAB10
!NewCodeFlag = $7FAB1C
!ExtraProp1 = $7FAB28
!ExtraProp2 = $7FAB34
!ExtraByte1 = $7FAB40
!ExtraByte2 = $7FAB4C
!ExtraByte3 = $7FAB58
!ExtraByte4 = $7FAB64
!ShooterExtraByte = $7FAB70
!GeneratorExtraByte = $7FAB78
!ScrollerExtraByte = $7FAB79
!CustomSpriteNumber = $7FAB9E
!ShooterExtraBits = $7FABAA
!GeneratorExtraBits = $7FABB2
!Layer1ExtraBits = $7FABB3
!Layer2ExtraBits = $7FABB4
!SpriteFlags = $7FABB5

if !sa1

!SpriteNumber = $3200
!SpriteYSpeed = $9E
!SpriteXSpeed = $B6
!SpriteMiscTable3 = $D8
!SpriteYLow = $3216
!SpriteXLow = $322C
!SpriteStatus = $3242
!SpriteYHigh = $3258
!SpriteXHigh = $326E
!SpriteYSpeedAccumulatingFraction = $74C8
!SpriteXSpeedAccumulatingFraction = $74DE
!SpriteMiscTable4 = $74F4
!SpriteMiscTable5 = $750A
!SpriteMiscTable6 = $3284
!SpriteMiscTable7 = $329A
!SpriteMiscTable8 = $32B0
!SpriteDecTimer1 = $32C6
!SpriteDecTimer2 = $32DC
!SpriteDecTimer3 = $32F2
!SpriteDecTimer4 = $3308
!SpriteMiscTable9 = $331E
!SpriteDirection = $3334
!SpriteBlockedStatus_ASB0UDLR = $334A
!SpriteMiscTable10 = $3360
!SpriteHOffScreenFlag = $3376
!SpriteDecTimer5 = $338C
!SpriteSlope = $7520
!SpriteHMoreThan4TilesOffScreenFlag = $7536
!SpriteYoshiTongueFlag = $754C
!SpriteInteractionWithObjectEnable = $7562
!SpriteIndexOAM = $33A2
!SpriteProperties_YXPPCCCT = $33B8
!SpriteMiscTable11 = $33CE
!SpriteMiscTable12 = $33E4
!SpriteLoadStatus = $7578
!SpriteMiscTable13 = $758E
!SpriteBehindEscenaryFlag = $75A4
!SpriteDecTimer6 = $33FA
!SpriteInLiquidFlag = $75BA
!SpriteTweaker1656_SSJJCCCC = $75D0
!SpriteTweaker1662_DSCCCCCC = $75EA
!SpriteTweaker166E_LWCFPPPG = $7600
!SpriteTweaker167A_DPMKSPIS = $7616
!SpriteTweaker1686_DNCTSWYE = $762C
!SpriteVOffScreenFlag = $7642
!SpriteMiscTable14 = $3410
!SpriteTweaker190F_WCDJ5SDP = $7658
!SpriteMiscTable15 = $766E
!SpriteDecTimer7 = $7FD6

!ExtraBits = $400040
!NewCodeFlag = $400056
!ExtraProp1 = $400057
!ExtraProp2 = $40006D
!ExtraByte1 = $4000A4
!ExtraByte2 = $4000BA
!ExtraByte3 = $4000D0
!ExtraByte4 = $4000E6
!ShooterExtraByte = $400110
!GeneratorExtraByte = $4000FC
!ScrollerExtraByte = $4000FD
!CustomSpriteNumber = $400083
!ShooterExtraBits = $400099
!GeneratorExtraBits = $4000A1
!Layer1ExtraBits = $4000A2
!Layer2ExtraBits = $4000A3
!SpriteFlags = $400118

endif 

;######################################
;############## Defines ###############
;######################################

!FrameIndex = !SpriteMiscTable1
!AnimationTimer = !SpriteDecTimer1
!AnimationIndex = !SpriteMiscTable2
!AnimationFrameIndex = !SpriteMiscTable3
!LocalFlip = !SpriteMiscTable4
!GlobalFlip = !SpriteMiscTable5

;######################################
;########### Init Routine #############
;######################################
print "INIT ",pc
	LDA #$00
	STA !GlobalFlip,x
	JSL InitWrapperChangeAnimationFromStart
    ;Here you can write your Init Code
    ;This will be excecuted when the sprite is spawned 
RTL

;######################################
;########## Main Routine ##############
;######################################
print "MAIN ",pc
    PHB
    PHK
    PLB
    JSR SpriteCode
    PLB
RTL

;>Routine: SpriteCode
;>Description: This routine excecute the logic of the sprite
;>RoutineLength: Short
Return:
RTS
SpriteCode:

    JSR GraphicRoutine                  ;Calls the graphic routine and updates sprite graphics

    ;Here you can put code that will be excecuted each frame even if the sprite is locked

    LDA !SpriteStatus,x			        
	CMP #$08                            ;if sprite dead return
	BNE Return	

	LDA !LockAnimationFlag				    
	BNE Return			                    ;if locked animation return.

    %SubOffScreen()

    JSR InteractMarioSprite
    ;After this routine, if the sprite interact with mario, Carry is Set.

    ;Here you can write your sprite code routine
    ;This will be excecuted once per frame excepts when 
    ;the animation is locked or when sprite status is not #$08

    JSR AnimationRoutine                ;Calls animation routine and decides the next frame to draw

    RTS

;>EndRoutine

;######################################
;######## Sub Routine Space ###########
;######################################

;Here you can write routines or tables

;Don't Delete or write another >Section Graphics or >End Section
;All code between >Section Graphics and >End Graphics Section will be changed by Dyzen : Sprite Maker
;>Section Graphics
;######################################
;########## Graphics Space ############
;######################################

;This space is for routines used for graphics
;if you don't know enough about asm then
;don't edit them.

;>Routine: GraphicRoutine
;>Description: Updates tiles on the oam map
;results will be visible the next frame.
;>RoutineLength: Short
GraphicRoutine:

    %GetDrawInfo()                     ;Calls GetDrawInfo to get the free slot and the XDisp and YDisp

    STZ !Scratch3                       ;$02 = Free Slot but in 16bits
    STY !Scratch2


    STZ !Scratch5
    LDA !GlobalFlip,x   
    ASL
    STA !Scratch4                       ;$04 = Global Flip but in 16bits


    PHX                                 ;Preserve X
    
    STZ !Scratch7
    LDA !FrameIndex,x
    STA !Scratch6                       ;$06 = Frame Index but in 16bits

    REP #$30                            ;A/X/Y 16bits mode
    LDY !Scratch4                       ;Y = Global Flip
    LDA !Scratch6
    ASL
	CLC
    ADC FramesFlippers,y
    TAX                                 ;X = Frame Index

    LDA FramesLength,x
    CMP #$FFFF
    BNE +
    SEP #$30
    PLX
    RTS
+
    STA !Scratch8

    LDA FramesEndPosition,x
    STA !Scratch4                       ;$04 = End Position + A value used to select a frame version that is flipped

    LDA FramesStartPosition,x           
    TAX                                 ;X = Start Position
    SEP #$20                            ;A 8bits mode
    LDY !Scratch2                       ;Y = Free Slot
    CPY #$00FD
    BCS .return                         ;Y can't be more than #$00FD
-
    LDA Tiles,x
    STA !TileCode,y                     ;Set the Tile code of the tile Y

    LDA Properties,x
    STA !TileProperty,y                 ;Set the Tile property of the tile Y

    LDA !Scratch0
	CLC
	ADC XDisplacements,x
	STA !TileXPosition,y                ;Set the Tile x pos of the tile Y

    LDA !Scratch1
	CLC
	ADC YDisplacements,x
	STA !TileYPosition,y                ;Set the Tile y pos of the tile Y

    PHY
	REP #$20                                 
    TYA
    LSR
    LSR
    TAY                                 ;Y = Y/4 because size directions are not continuous to map 200 and 300
	SEP #$20
    LDA Sizes,x
    STA !TileSize460,y                  ;Set the Tile size of the tile Y
    PLY

    INY
    INY
    INY
    INY                                 ;Next OAM Slot
    CPY #$00FD
    BCS .return                         ;Y can't be more than #$00FD

    DEX
    BMI .return
    CPX !Scratch4                       ;if X < start position or is negative then return
    BCS -                               ;else loop

.return
    SEP #$10
    PLX                                 ;Restore X
    
    LDY #$FF                            ;Allows mode of 8 or 16 bits
    LDA !Scratch8                       ;Load the number of tiles used by the frame
    JSL $01B7B3|!rom                  		;This insert the new tiles into the oam, 
                                        ;A = #$00 => only tiles of 8x8, A = #$02 = only tiles of 16x16, A = #$04 = tiles of 8x8 or 16x16
                                        ;if you select A = #$04 then you must put the sizes of the tiles in !TileSize
RTS
;>EndRoutine

;All words that starts with '@' and finish with '.' will be replaced by Dyzen

;>Table: FramesLengths
;>Description: How many tiles use each frame.
;>ValuesSize: 16
FramesLength:
    dw $0025,$0030,$0023,$002E
	dw $0025,$0030,$0023,$002E
;>EndTable


;>Table: FramesFlippers
;>Description: Values used to add values to FramesStartPosition and FramesEndPosition
;To use a flipped version of the frames.
;>ValuesSize: 16
FramesFlippers:
    dw $0000,$0008
;>EndTable


;>Table: FramesStartPosition
;>Description: Indicates the index where starts each frame
;>ValuesSize: 16
FramesStartPosition:
    dw $0025,$0056,$007A,$00A9
	dw $00CF,$0100,$0124,$0153
;>EndTable

;>Table: FramesEndPosition
;>Description: Indicates the index where end each frame
;>ValuesSize: 16
FramesEndPosition:
    dw $0000,$0026,$0057,$007B
	dw $00AA,$00D0,$0101,$0125
;>EndTable


;>Table: Tiles
;>Description: Tiles codes of each tile of each frame
;>ValuesSize: 8
Tiles:
    
Frame0_Chase1_Tiles:
	db $AA,$68,$87,$A7,$89,$A9,$8A,$AA,$00,$20,$40,$60,$02,$22,$42,$62
	db $04,$24,$44,$64,$06,$26,$46,$66,$08,$28,$48,$68,$3A,$3C,$3E,$80
	db $A0,$82,$A2,$83,$A3,$CA
Frame1_Chase2_Tiles:
	db $0A,$1A,$0C,$1C,$0E,$1E,$C0,$E0,$C2,$E2,$C3,$E3,$D5,$E5,$E7,$E8
	db $8C,$AC,$8E,$AE,$CC,$EC,$CE,$EE,$CB,$DB,$EB,$FB,$DA,$EA,$C5,$C6
	db $C7,$C8,$C9,$CA,$4C,$4D,$4E,$4F,$4F,$D8,$D9,$0A,$1A,$0C,$1C,$0E
	db $1E
Frame2_Chase3_Tiles:
	db $80,$A0,$82,$A2,$83,$A3,$00,$20,$40,$60,$02,$22,$42,$62,$04,$24
	db $44,$64,$06,$26,$46,$66,$08,$28,$48,$68,$3A,$3C,$3E,$CA,$87,$A7
	db $89,$A9,$8A,$AA
Frame3_Chase4_Tiles:
	db $0A,$1A,$0C,$1C,$0E,$1E,$C0,$E0,$C2,$E2,$C3,$E3,$E5,$E7,$E8,$D5
	db $CB,$EB,$CD,$ED,$CE,$EE,$DA,$EA,$C5,$C6,$C7,$C8,$C9,$CA,$4C,$4D
	db $4E,$4F,$4F,$8C,$AC,$8E,$AE,$D8,$D9,$0A,$1A,$0C,$1C,$0E,$1E
Frame0_Chase1_TilesFlipX:
	db $AA,$68,$87,$A7,$89,$A9,$8A,$AA,$00,$20,$40,$60,$02,$22,$42,$62
	db $04,$24,$44,$64,$06,$26,$46,$66,$08,$28,$48,$68,$3A,$3C,$3E,$80
	db $A0,$82,$A2,$83,$A3,$CA
Frame1_Chase2_TilesFlipX:
	db $0A,$1A,$0C,$1C,$0E,$1E,$C0,$E0,$C2,$E2,$C3,$E3,$D5,$E5,$E7,$E8
	db $8C,$AC,$8E,$AE,$CC,$EC,$CE,$EE,$CB,$DB,$EB,$FB,$DA,$EA,$C5,$C6
	db $C7,$C8,$C9,$CA,$4C,$4D,$4E,$4F,$4F,$D8,$D9,$0A,$1A,$0C,$1C,$0E
	db $1E
Frame2_Chase3_TilesFlipX:
	db $80,$A0,$82,$A2,$83,$A3,$00,$20,$40,$60,$02,$22,$42,$62,$04,$24
	db $44,$64,$06,$26,$46,$66,$08,$28,$48,$68,$3A,$3C,$3E,$CA,$87,$A7
	db $89,$A9,$8A,$AA
Frame3_Chase4_TilesFlipX:
	db $0A,$1A,$0C,$1C,$0E,$1E,$C0,$E0,$C2,$E2,$C3,$E3,$E5,$E7,$E8,$D5
	db $CB,$EB,$CD,$ED,$CE,$EE,$DA,$EA,$C5,$C6,$C7,$C8,$C9,$CA,$4C,$4D
	db $4E,$4F,$4F,$8C,$AC,$8E,$AE,$D8,$D9,$0A,$1A,$0C,$1C,$0E,$1E
;>EndTable


;>Table: Properties
;>Description: Properties of each tile of each frame
;>ValuesSize: 8
Properties:
    
Frame0_Chase1_Properties:
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2E,$2E
Frame1_Chase2_Properties:
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$6E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E
Frame2_Chase3_Properties:
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E
Frame3_Chase4_Properties:
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$6E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
Frame0_Chase1_PropertiesFlipX:
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6E,$6E
Frame1_Chase2_PropertiesFlipX:
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$2E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E
Frame2_Chase3_PropertiesFlipX:
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E
Frame3_Chase4_PropertiesFlipX:
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$2E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
;>EndTable
;>Table: XDisplacements
;>Description: X Displacement of each tile of each frame
;>ValuesSize: 8
XDisplacements:
    
Frame0_Chase1_XDisp:
	db $38,$40,$20,$20,$30,$30,$38,$38,$E8,$E8,$E8,$E8,$F8,$F8,$F8,$F8
	db $08,$08,$08,$08,$18,$18,$18,$18,$28,$28,$28,$28,$E8,$F8,$08,$D0
	db $D0,$E0,$E0,$E8,$E8,$16
Frame1_Chase2_XDisp:
	db $F0,$F0,$00,$00,$10,$10,$E8,$E8,$F8,$F8,$00,$00,$10,$10,$20,$28
	db $18,$18,$28,$28,$F8,$F8,$08,$08,$F0,$F0,$F0,$F0,$E8,$E8,$F0,$F8
	db $00,$08,$10,$18,$FA,$02,$0A,$12,$F4,$20,$28,$F0,$F0,$00,$00,$10
	db $10
Frame2_Chase3_XDisp:
	db $D0,$D0,$E0,$E0,$E8,$E8,$E8,$E8,$E8,$E8,$F8,$F8,$F8,$F8,$08,$08
	db $08,$08,$18,$18,$18,$18,$28,$28,$28,$28,$E8,$F8,$08,$16,$20,$20
	db $30,$30,$38,$38
Frame3_Chase4_XDisp:
	db $F0,$F0,$00,$00,$10,$10,$E8,$E8,$F8,$F8,$00,$00,$10,$20,$28,$10
	db $F0,$F0,$00,$00,$08,$08,$E8,$E8,$F0,$F8,$00,$08,$10,$18,$FC,$04
	db $0C,$12,$F4,$18,$18,$28,$28,$20,$28,$F0,$F0,$00,$00,$10,$10
Frame0_Chase1_XDispFlipX:
	db $C8,$C0,$E0,$E0,$D0,$D0,$C8,$C8,$18,$18,$18,$18,$08,$08,$08,$08
	db $F8,$F8,$F8,$F8,$E8,$E8,$E8,$E8,$D8,$D8,$D8,$D8,$18,$08,$F8,$30
	db $30,$20,$20,$18,$18,$F2
Frame1_Chase2_XDispFlipX:
	db $10,$10,$00,$00,$F0,$F0,$18,$18,$08,$08,$00,$00,$F0,$F0,$E0,$D8
	db $E8,$E8,$D8,$D8,$08,$08,$F8,$F8,$18,$18,$18,$18,$20,$20,$18,$10
	db $08,$00,$F8,$F0,$0E,$06,$FE,$F6,$14,$E8,$E0,$10,$10,$00,$00,$F0
	db $F0
Frame2_Chase3_XDispFlipX:
	db $30,$30,$20,$20,$18,$18,$18,$18,$18,$18,$08,$08,$08,$08,$F8,$F8
	db $F8,$F8,$E8,$E8,$E8,$E8,$D8,$D8,$D8,$D8,$18,$08,$F8,$F2,$E0,$E0
	db $D0,$D0,$C8,$C8
Frame3_Chase4_XDispFlipX:
	db $10,$10,$00,$00,$F0,$F0,$18,$18,$08,$08,$00,$00,$F0,$E0,$D8,$F8
	db $10,$10,$00,$00,$F8,$F8,$20,$20,$18,$10,$08,$00,$F8,$F0,$0C,$04
	db $FC,$F6,$14,$E8,$E8,$D8,$D8,$E8,$E0,$10,$10,$00,$00,$F0,$F0
;>EndTable
;>Table: YDisplacements
;>Description: Y Displacement of each tile of each frame
;>ValuesSize: 8
YDisplacements:
    
Frame0_Chase1_YDisp:
	db $F8,$F8,$E8,$F8,$E8,$F8,$E8,$F8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8
	db $B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$F8,$F8,$F8,$E8
	db $F8,$E8,$F8,$E8,$F8,$F8
Frame1_Chase2_YDisp:
	db $F0,$F8,$F0,$F8,$F0,$F8,$B8,$C8,$B8,$C8,$B8,$C8,$C0,$C8,$C8,$C8
	db $D8,$E8,$D8,$E8,$D8,$E8,$D8,$E8,$D8,$E0,$E8,$F0,$E0,$E8,$F8,$F8
	db $F8,$F8,$F8,$F8,$00,$00,$00,$00,$00,$F8,$F8,$D8,$E0,$D8,$E0,$D8
	db $E0
Frame2_Chase3_YDisp:
	db $E8,$F8,$E8,$F8,$E8,$F8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$B8,$C8
	db $D8,$E8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$F8,$F8,$F8,$F8,$E8,$F8
	db $E8,$F8,$E8,$F8
Frame3_Chase4_YDisp:
	db $D8,$E0,$D8,$E0,$D8,$E0,$B8,$C8,$B8,$C8,$B8,$C8,$C8,$C8,$C8,$C0
	db $D8,$E8,$D8,$E8,$D8,$E8,$E0,$E8,$F8,$F8,$F8,$F8,$F8,$F8,$00,$00
	db $00,$00,$00,$D8,$E8,$D8,$E8,$F8,$F8,$F0,$F8,$F0,$F8,$F0,$F8
Frame0_Chase1_YDispFlipX:
	db $F8,$F8,$E8,$F8,$E8,$F8,$E8,$F8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8
	db $B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$F8,$F8,$F8,$E8
	db $F8,$E8,$F8,$E8,$F8,$F8
Frame1_Chase2_YDispFlipX:
	db $F0,$F8,$F0,$F8,$F0,$F8,$B8,$C8,$B8,$C8,$B8,$C8,$C0,$C8,$C8,$C8
	db $D8,$E8,$D8,$E8,$D8,$E8,$D8,$E8,$D8,$E0,$E8,$F0,$E0,$E8,$F8,$F8
	db $F8,$F8,$F8,$F8,$00,$00,$00,$00,$00,$F8,$F8,$D8,$E0,$D8,$E0,$D8
	db $E0
Frame2_Chase3_YDispFlipX:
	db $E8,$F8,$E8,$F8,$E8,$F8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$B8,$C8
	db $D8,$E8,$B8,$C8,$D8,$E8,$B8,$C8,$D8,$E8,$F8,$F8,$F8,$F8,$E8,$F8
	db $E8,$F8,$E8,$F8
Frame3_Chase4_YDispFlipX:
	db $D8,$E0,$D8,$E0,$D8,$E0,$B8,$C8,$B8,$C8,$B8,$C8,$C8,$C8,$C8,$C0
	db $D8,$E8,$D8,$E8,$D8,$E8,$E0,$E8,$F8,$F8,$F8,$F8,$F8,$F8,$00,$00
	db $00,$00,$00,$D8,$E8,$D8,$E8,$F8,$F8,$F0,$F8,$F0,$F8,$F0,$F8
;>EndTable
;>Table: Sizes.
;>Description: size of each tile of each frame
;>ValuesSize: 8
Sizes:
    
Frame0_Chase1_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$00
Frame1_Chase2_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00,$00,$00,$00,$00,$00
	db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$02,$02,$02,$02
	db $02
Frame2_Chase3_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$02,$02
	db $02,$02,$02,$02
Frame3_Chase4_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00
	db $02,$02,$02,$02,$02,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	db $00,$00,$00,$02,$02,$02,$02,$00,$00,$02,$02,$02,$02,$02,$02
Frame0_Chase1_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$00
Frame1_Chase2_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00,$00,$00,$00,$00,$00
	db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$02,$02,$02,$02
	db $02
Frame2_Chase3_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$02,$02
	db $02,$02,$02,$02
Frame3_Chase4_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00
	db $02,$02,$02,$02,$02,$02,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	db $00,$00,$00,$02,$02,$02,$02,$00,$00,$02,$02,$02,$02,$02,$02
;>EndTable

;>End Graphics Section

;Don't Delete or write another >Section Animation or >End Section
;All code between >Section Animations and >End Animations Section will be changed by Dyzen : Sprite Maker
;>Section Animations
;######################################
;########## Animation Space ###########
;######################################

;This space is for routines used for graphics
;if you don't know enough about asm then
;don't edit them.
InitWrapperChangeAnimationFromStart:
	PHB
    PHK
    PLB
	STZ !AnimationIndex,x
	JSR ChangeAnimationFromStart
	PLB
	RTL

ChangeAnimationFromStart_Chase:
	STZ !AnimationIndex,x


ChangeAnimationFromStart:
	STZ !AnimationFrameIndex,x

	STZ !Scratch1
	LDA !AnimationIndex,x
	STA !Scratch0					;$00 = Animation index in 16 bits

	STZ !Scratch3
	LDA !AnimationFrameIndex,x
	STA !Scratch2					;$02 = Animation Frame index in 16 bits

	STZ !Scratch5
	STX !Scratch4					;$04 = sprite index in 16 bits

	REP #$30						;A7X/Y of 16 bits
	LDX !Scratch4					;X = sprite index in 16 bits

	LDA !Scratch0
	ASL
	TAY								;Y = 2*Animation index

	LDA !Scratch2
	CLC
	ADC AnimationIndexer,y
	TAY								;Y = Position of the first frame of the animation + animation frame index

	SEP #$20						;A of 8 bits

	LDA Frames,y
	STA !FrameIndex,x				;New Frame = Frames[New Animation Frame Index]

	LDA Times,y
	STA !AnimationTimer,x			;Time = Times[New Animation Frame Index]

	LDA !Scratch2
	STA !AnimationFrameIndex,x

	SEP #$10						;X/Y of 8 bits
	LDX !Scratch4					;X = sprite index in 8 bits
RTS
	

;>Routine: AnimationRoutine
;>Description: Decides what will be the next frame.
;>RoutineLength: Short
AnimationRoutine:
    LDA !AnimationTimer,x
    BEQ +

	RTS

+
	STZ !Scratch1
	LDA !AnimationIndex,x
	STA !Scratch0					;$00 = Animation index in 16 bits

	STZ !Scratch3
	LDA !AnimationFrameIndex,x
	STA !Scratch2					;$02 = Animation Frame index in 16 bits

	STZ !Scratch5
	STX !Scratch4					;$04 = sprite index in 16 bits

	REP #$30						;A7X/Y of 16 bits
	LDX !Scratch4					;X = sprite index in 16 bits

	LDA !Scratch0
	ASL
	TAY								;Y = 2*Animation index

	INC !Scratch2					;New Animation Frame Index = Animation Frame Index + 1

	LDA !Scratch2			        ;if Animation Frame index < Animation Lenght then Animation Frame index++
	CMP AnimationLenght,y			;else go to the frame where start the loop.
	BCC +							

	LDA AnimationLastTransition,y
	STA !Scratch2					;New Animation Frame Index = first frame of the loop.

+
	LDA !Scratch2
	CLC
	ADC AnimationIndexer,y
	TAY								;Y = Position of the first frame of the animation + animation frame index

	SEP #$20						;A of 8 bits

	LDA Frames,y
	STA !FrameIndex,x				;New Frame = Frames[New Animation Frame Index]

	LDA Times,y
	STA !AnimationTimer,x			;Time = Times[New Animation Frame Index]

	LDA !Scratch2
	STA !AnimationFrameIndex,x

	SEP #$10						;X/Y of 8 bits
	LDX !Scratch4					;X = sprite index in 8 bits
RTS
;>EndRoutine

;All words that starts with '>' and finish with '.' will be replaced by Dyzen

AnimationLenght:
	dw $0004

AnimationLastTransition:
	dw $0000

AnimationIndexer:
	dw $0000

Frames:
	
Animation0_Chase_Frames:
	db $00,$01,$02,$03

Times:
	
Animation0_Chase_Times:
	db $04,$04,$04,$04
;>End Animations Section

;Don't Delete or write another >Section Hitbox Interaction or >End Section
;All code between >Section Hitboxes Interaction and >End Hitboxes Interaction Section will be changed by Dyzen : Sprite Maker
;>Section Hitboxes Interaction
;######################################
;######## Interaction Space ###########
;######################################

InteractMarioSprite:
	LDA !SpriteTweaker167A_DPMKSPIS,x
	AND #$20
	BNE ProcessInteract      
	TXA                       
	EOR !TrueFrameCounter      			
	AND #$01                	
	ORA !SpriteHOffScreenFlag,x 				
	BEQ ProcessInteract       
ReturnNoContact:
	CLC                       
	RTS
ProcessInteract:
	%SubHorzPos()
	LDA !ScratchF                  
	CLC                       
	ADC #$50                
	CMP #$A0                
	BCS ReturnNoContact       ; No contact, return 
	%SubVertPos()         
	LDA !ScratchE                   
	CLC                       
	ADC #$60                
	CMP #$C0                
	BCS ReturnNoContact       ; No contact, return 
	LDA $71    ; \ If animation sequence activated... 
	CMP #$01                ;  | 
	BCS ReturnNoContact       ; / ...no contact, return 
	LDA #$00                ; \ Branch if bit 6 of $0D9B set? 
	BIT $0D9B|!addr               ;  | 
	BVS +           ; / 
	LDA $13F9|!addr ; \ If Mario and Sprite not on same side of scenery... 
	EOR !SpriteBehindEscenaryFlag,x ;  |
+
	BNE ReturnNoContact2
	JSL $03B664|!rom				; MarioClipping
	JSR Interaction

	BCC ReturnNoContact2
	LDA !ScratchE
	CMP #$01
	BNE +
	JSR DefaultAction
+
	SEC
	RTS
ReturnNoContact2:
	CLC
	RTS

Interaction:
    STZ !ScratchE
	LDA !GlobalFlip,x
    ASL
	TAY                     ;Y = Flip Adder, used to jump to the frame with the current flip

    LDA !FrameIndex,x
	STA !Scratch4
	STZ !Scratch5

    REP #$20
	LDA !Scratch4
	ASL
	CLC
	ADC HitboxAdder,y
	REP #$10
	TAY

    LDA FrameHitboxesIndexer,y
    TAY
    SEP #$20

-
    LDA FrameHitBoxes,y
    CMP #$FF
    BNE +
    LDA !ScratchE
    BNE ++
	SEP #$10
	LDX !SpriteIndex
    CLC
    RTS
++
	SEP #$10
	LDX !SpriteIndex
    SEC
    RTS
+
    STA !Scratch4
    STZ !Scratch5
    PHY

    REP #$20
    LDA !Scratch4
    ASL
    TAY

    LDA HitboxesStart,y
    TAY
    SEP #$20
+

	STZ !ScratchA
    LDA Hitboxes+1,y
    STA !Scratch4           ;$04 = Low X Offset
    BPL +
    LDA #$FF
    STA !ScratchA           ;$0A = High X offset
+

	STZ !ScratchB
    LDA Hitboxes+2,y
    STA !Scratch5           ;$05 = Low Y Offset
    BPL +
    LDA #$FF
    STA !ScratchB           ;$0B = High Y Offset
+

    LDA Hitboxes+3,y
    STA !Scratch6           ;$06 = Width

    LDA Hitboxes+4,y
    STA !Scratch7           ;$07 = Height

	PHY
	SEP #$10
	LDX !SpriteIndex

	LDA !SpriteXHigh,x
	XBA
	LDA !SpriteXLow,x
	REP #$20
	PHA
	SEP #$20

	LDA !ScratchA
	XBA
	LDA !Scratch4
	REP #$20
	CLC
	ADC $01,s
	PHA
	SEP #$20
	PLA 
	STA !Scratch4
	PLA
	STA !ScratchA
	PLA
	PLA

	LDA !SpriteYHigh,x
	XBA
	LDA !SpriteYLow,x
	REP #$20
	PHA
	SEP #$20

	LDA !ScratchB
	XBA
	LDA !Scratch5
	REP #$20
	CLC
	ADC $01,s
	PHA
	SEP #$20
	PLA 
	STA !Scratch5
	PLA
	STA !ScratchB
	PLA
	PLA

    JSL $03B72B|!rom
	REP #$10
	BCS ++
	PLY
	PLY
	INY
	JMP -
++
	PLY
	PLY
	LDA !ScratchE
	ORA #$01
	STA !ScratchE
	SEP #$10
	LDX !SpriteIndex
	SEC
	RTS

HitboxAdder:
    dw $0000,$0008

FrameHitboxesIndexer:
    dw $0000,$0002,$0004,$0006
	dw $0008,$000A,$000C,$000E

FrameHitBoxes:
    db $00,$FF
	db $00,$FF
	db $00,$FF
	db $00,$FF
	
	db $01,$FF
	db $01,$FF
	db $01,$FF
	db $01,$FF
	

HitboxesStart:
    dw $0000,$0006

Hitboxes:
    db $01,$EF,$B9,$44,$4F,$00
	db $01,$DD,$B9,$44,$4F,$00
	

;This routine will be executed when mario interact with a standar hitbox.
;It will be excecuted if $0E is 1 after execute Interaction routine
DefaultAction:
RTS
    
;>End Hitboxes Interaction Section